import Utilities.gui_creator as gc
import Utilities.mccdaq_operations as mo
import numpy as np
import threading
import time

board_num, channel = 0, 0
ai_range = mo.chan_range('bipolar_10')


root = gc.create_window(title='Digital Thermometer',
                        size='300x100')

lbl_2 = gc.create_indicator(root,
                            label_1='Temperature (deg Celsius)')


a_1 = 2.53154843e+01
a_2 = -4.01290844e-01
a_3 = 8.86954692e-02
a_4 = -3.26745427e-02
a_5 = 9.62693095e-03
a_6 = -1.43419649e-03
a_7 = 1.10144045e-04
a_8 = -4.23537225e-06
a_9 = 6.48659056e-08


def acquire_sample():

    while btn.cget('text') == 'Stop':

        voltage = mo.read_sample(board_num, channel,
                                    ai_range)
        
        degree_celsius = (voltage - 1.25)/0.005

#        v = (voltage - 1.25 - 0.00125)/122.4

#        Convert v to millivolts
#        v = v*1000
#        degree_celsius = (a_1*v + a_2*v**2 + a_3*v**3 + a_4*v**4 + a_5*v**5
#                          + a_6*v**6 + a_7*v**7 + a_8*v**8 + a_9*v**9)   
        
        string_temperature = f'{degree_celsius:.1f}'

        lbl_2.config(text=string_temperature)                

        time.sleep(0.1)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return


btn = gc.action_button(root, label='Start', action=toggle)

root.mainloop()
